//package caveman;

//required packages
import java.io.File;
import java.io.FileWriter;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JTextArea;
import javax.swing.JMenuItem;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.JFileChooser;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.JOptionPane;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Font;

//primary GUI frame for CaveMan
public class GUIFrame extends JFrame{
	// serial version UID (abstract requirement from JFrame, not used)
	public static final long serialVersionUID = 1;
	
	//CaveMan Icon
	public static final String ICON_FILE_PATH = "icon.png";
	public static final String TITLE = "CaveMan 0.1 Rootkit Detector";
	
	//GUI components
	JTextArea statusBar;
	JTextArea resultsWindow;
	JMenuBar mainMenu;
	JMenu fileMenu;
	JMenuItem saveReport;
	JMenuItem exit;
	JMenu scanMenu;
	JMenuItem scanForRootkits;
	JMenu aboutMenu;
	JMenuItem helpItem;
	JMenuItem informationItem;
	JOptionPane dialogBox;
	JFileChooser saveReportFile;
	
	// default constructor
	public GUIFrame(){
		//set the icon for the frame
		File imageFile = new File(ICON_FILE_PATH);
		
		//test for existence of the image
		if ( imageFile.exists() ){
		   try {
			  //set the CaveMan icon
			  setIconImage(new ImageIcon(imageFile.toURL()).getImage());
		   } catch (NullPointerException npe){
			  //ignore the case where no icon exists, simply allow the frame to open
		   } catch (MalformedURLException mue){
			  //ignore the case where no icon exists, simply allow the frame to open 
		   }
		}

		//set to use system look and feel decorations of user, otherwise use default java
		//settings (which are pretty dang ugly)
		try {
		   UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (IllegalAccessException iae){
			setDefaultLookAndFeelDecorated(true);
		} catch (InstantiationException ie){
			setDefaultLookAndFeelDecorated(true);
		} catch (UnsupportedLookAndFeelException ulafe){
			setDefaultLookAndFeelDecorated(true);
		} catch (ClassNotFoundException cnfe){
			setDefaultLookAndFeelDecorated(true);
		}
		
		//other main JFrame parameters
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setName(TITLE);
		setTitle(TITLE);
		setResizable(false);
		setBounds(50,50,400,400);
		
		//set up all GUI components
		initializeComponents();
		
		//finalize display
		validate();
		setVisible(true);
	}
	
	//create all GUI components
	private void initializeComponents(){
		statusBar = new JTextArea();
		resultsWindow = new JTextArea();
		mainMenu = new JMenuBar();
		fileMenu = new JMenu("File");
		saveReport = new JMenuItem("Save Report");
		exit = new JMenuItem("Exit");
		scanMenu = new JMenu("Scan");
		scanForRootkits = new JMenuItem("Poke Around for Rootkits");
		aboutMenu = new JMenu("About");
		helpItem = new JMenuItem("Help");
		informationItem = new JMenuItem("CaveMan Info");
		dialogBox = new JOptionPane();
		saveReportFile = new JFileChooser();
		
		//setup GUI information
		
		//setup menu bar information
		setJMenuBar(mainMenu);
		add(resultsWindow);
		add(statusBar);
		setLayout(null);
		
		mainMenu.add(fileMenu);
		mainMenu.add(scanMenu);
		mainMenu.add(aboutMenu);
		mainMenu.setEnabled(true);
		mainMenu.setFont(new Font("Verdana", Font.PLAIN, 12));
		fileMenu.add(saveReport);
		fileMenu.addSeparator();
		fileMenu.add(exit);
		scanMenu.add(scanForRootkits);
		aboutMenu.add(helpItem);
		aboutMenu.add(informationItem);
		
		//menu action listeners
		exit.addMouseListener(new FileMenu_ExitActionListener());
		saveReport.addMouseListener(new FileMenu_SaveReportActionListener());
		scanForRootkits.addMouseListener(new ScanMenu_ScanForRootkitsActionListener());
		helpItem.addMouseListener(new AboutMenu_HelpActionListener());
		informationItem.addMouseListener(new AboutMenu_InformationActionListener());
		
		//error message/status information bar
		statusBar.setFont(new Font("Verdana", Font.PLAIN, 9));
		statusBar.setBounds(3,304,390,42);
		statusBar.setBorder(BorderFactory.createEtchedBorder());
		statusBar.setForeground(Color.BLACK);
		statusBar.setEditable(false);
		statusBar.setAutoscrolls(true);
		statusBar.setLineWrap(false);
		statusBar.setText("CaveMan rootkit detector successfully initialized!");
		
		//results window
		resultsWindow.setFont(new Font("Verdana", Font.PLAIN, 9));
		resultsWindow.setBounds(new Rectangle(3,2,390,300));
		resultsWindow.setBorder(BorderFactory.createEtchedBorder());
		resultsWindow.setForeground(Color.BLACK);
		resultsWindow.setEditable(false);
		resultsWindow.setAutoscrolls(true);
		resultsWindow.setLineWrap(false);
		resultsWindow.setText("No results to display.");
		
		//setup menu bar information
		mainMenu.add(fileMenu);
		mainMenu.add(scanMenu);
		mainMenu.add(aboutMenu);
		mainMenu.setEnabled(true);
		mainMenu.setFont(new Font("Verdana", Font.PLAIN, 12));
		fileMenu.add(saveReport);
		fileMenu.addSeparator();
		fileMenu.add(exit);
		scanMenu.add(scanForRootkits);
		aboutMenu.add(helpItem);
		aboutMenu.add(informationItem);
	}
	
	//save a report
	public void saveFileAs(){
	   File destinationFile;
	   BufferedWriter bw;
	   int result;
	   
	   saveReportFile.setCurrentDirectory(new File("./"));
	   result = saveReportFile.showSaveDialog(this);
	   
	   //if the user selects a filename
	   if ( result == JFileChooser.APPROVE_OPTION ){
		   destinationFile = saveReportFile.getSelectedFile();
		   
		   //attempt to write the contents of the results to the report file
		   try {
		      if ( destinationFile.exists() ){
		         result = JOptionPane.showConfirmDialog(this, "Report file already exists.  Overwrite?",
		        		                                "Confirm Report Replace", JOptionPane.YES_NO_OPTION);
		         if ( result != JOptionPane.OK_OPTION ){
		        	 return;
		         }
		      }
		      
		      //write the report using the contents of the results window
		      bw = new BufferedWriter(new FileWriter(destinationFile));
		      bw.write(resultsWindow.getText());
		      bw.close();
		      displayMessage("Report generated successfully!");
		   } catch (IOException ioe){
		     displayMessage("Could not save report file.");    
		   }
	   } else {
		   return;
	   }
	}
	
	//check for rootkits
	public void scanForRootkits(){
		//local variables
		String programOutput;
		String nextLine;
		Process batchProcess;
		BufferedReader reader;
		File resultsDirectory = new File("./results/");
		int numThreats = 0;
		int decisionResult = JOptionPane.NO_OPTION;
		
		//check to see if the tool has been run already
		if ( resultsDirectory.exists() && resultsDirectory.listFiles().length > 0 ){
			decisionResult = JOptionPane.showConfirmDialog(this, "Analyze old results files? (Negative reply will cause a full scan)",
                                                           "Rootkit Analysis", JOptionPane.YES_NO_OPTION);	
		}
		
		//run the complete scan only if the user chooses "No"
		if ( decisionResult == JOptionPane.NO_OPTION ){
			//attempt to run the script
			try {
				programOutput = "";
				batchProcess = Runtime.getRuntime().exec("./j_4ensics_v0.1.bat");
				reader = new BufferedReader(new InputStreamReader(batchProcess.getErrorStream()));
				while ( (nextLine = reader.readLine()) != null ){
					//test for certain conditions in the batch file output
					if ( nextLine.toLowerCase().contains("caveman done") ){
						break; //exit once the script terminates
					}
					programOutput += nextLine + "\n";
		   			}
			} catch (IOException ioe){
				displayMessage("Error executing script ... stopping rootkit scan.");
				return;
			} catch (RuntimeException re){
				displayMessage("Error executing script ... stopping rootkit scan.");
				return;
			}
			displayMessage("Completed running scan, analyzing results...");
		}
		
		//analyze results
		resultsWindow.setText("");
		
		//get string representations of each file
		File apiHookCheck = new File("./results/APIHookCheck.txt");
		String apiHookCheckData = "";
		File arp = new File("./results/arp.txt");
		String arpData = "";
		File auditpol = new File("./results/auditpol.txt");
		String auditpolData = "";
		File dirHiddenFiles = new File("./results/dirHiddenFiles.txt");
		String dirHiddenFilesData = "";
		File fport = new File("./results/fport.txt");
		String fportData = "";
		File hfind = new File("./results/hfind.txt");
		String hfindData = "";
		File ipconfig_OUT = new File("./results/ipconfig_OUT.txt");
		String ipconfig_OUTData = "";
		File mem_OUT = new File("./results/mem_OUT.txt");
		String mem_OUTData = "";
		File netstat_an_out = new File("./results/netstat_an_out.txt");
		String netstat_an_outData = "";
		File netstat_anp_out = new File("./results/netstat_anp_out.txt");
		String netstat_anp_outData = "";
		File netstat_anr_out = new File("./results/netstat_anr_out.txt");
		String netstat_anr_outData = "";
		File route_out = new File("./results/route_out.txt");
		String route_outData = "";
		File handle = new File("./results/handle.txt");
		String handleData = "";
		File listdlls = new File("./results/listdlls.txt");
		String listdllsData = "";
		File nbtstat = new File("./results/nbtstat.txt");
		String nbtstatData = "";
		File procinterrogate = new File("./results/procinterrogate.txt");
		String procinterrogateData = "";
		File ps = new File("./results/ps.txt");
		String psData = "";
		File psfile = new File("./results/psfile.txt");
		String psfileData = "";
		File psinfo = new File("./results/psinfo.txt");
		String psinfoData = "";
		File pslist = new File("./results/pslist.txt");
		String pslistData = "";
		File psloggedon = new File("./results/psloggedon.txt");
		String psloggedonData = "";
		File psservice = new File("./results/psservice.txt");
		String psserviceData = "";
		File pulist = new File("./results/pulist.txt");
		String pulistData = "";
		File prefetch = new File("./results/prefetch.txt");
		String prefetchData = "";
		File sfind = new File("./results/sfind.txt");
		String sfindData = "";
		File streams = new File("./results/streams.txt");
		String streamsData = "";
		File dumpelAppLog = new File("./results/dumpelAppLog.txt");
		String dumpelAppLogData = "";
		File dumpelSecLog = new File("./results/dumpelSecLog.txt");
		String dumpelSecLogData = "";
		File dumpelSysLog = new File("./results/dumpelSysLog.txt");
		String dumpelSysLogData = "";
		File promiscDetect = new File("./results/promiscDetect.txt");
		String promiscDetectData = "";
		File Tasklist = new File("./results/Tasklist.txt");
		String TasklistData = "";
		File tcpvcon = new File("./results/tcpvcon.txt");
		String tcpvconData = "";
		File sl = new File("./results/sl.txt");
		String slData = "";
		File ls = new File("./results/ls.txt");
		String lsData = "";	
		
		//test for output file existence (API Hooks)
		try {
		   if ( apiHookCheck.exists() ){
		      reader = new BufferedReader(new FileReader(apiHookCheck));
		      while ( (nextLine = reader.readLine()) != null ){
		         apiHookCheckData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (ARP entries)
		try {
		   if ( arp.exists() ){
		      reader = new BufferedReader(new FileReader(arp));
		      while ( (nextLine = reader.readLine()) != null ){
		         arpData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (Audit Policies)
		try {
		   if ( auditpol.exists() ){
		      reader = new BufferedReader(new FileReader(auditpol));
		      while ( (nextLine = reader.readLine()) != null ){
		         auditpolData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (Hidden Files)
		try {
		   if ( dirHiddenFiles.exists() ){
		      reader = new BufferedReader(new FileReader(dirHiddenFiles));
		      while ( (nextLine = reader.readLine()) != null ){
		         dirHiddenFilesData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (fport)
		try {
		   if ( fport.exists() ){
		      reader = new BufferedReader(new FileReader(fport));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  fportData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (hfind)
		try {
		   if ( hfind.exists() ){
		      reader = new BufferedReader(new FileReader(hfind));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  hfindData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (ipconfig_OUT)
		try {
		   if ( ipconfig_OUT.exists() ){
		      reader = new BufferedReader(new FileReader(ipconfig_OUT));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  ipconfig_OUTData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (mem_OUT)
		try {
		   if ( mem_OUT.exists() ){
		      reader = new BufferedReader(new FileReader(mem_OUT));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  mem_OUTData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (netstat_an_out)
		try {
		   if ( netstat_an_out.exists() ){
		      reader = new BufferedReader(new FileReader(netstat_an_out));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  netstat_an_outData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (netstat_anp_out)
		try {
		   if ( netstat_anp_out.exists() ){
		      reader = new BufferedReader(new FileReader(netstat_anp_out));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  netstat_anp_outData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (netstat_anr_out)
		try {
		   if ( netstat_anr_out.exists() ){
		      reader = new BufferedReader(new FileReader(netstat_anr_out));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  netstat_anr_outData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (route_out)
		try {
		   if ( route_out.exists() ){
		      reader = new BufferedReader(new FileReader(route_out));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  route_outData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (handle)
		try {
		   if ( handle.exists() ){
		      reader = new BufferedReader(new FileReader(handle));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  handleData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (handle)
		try {
		   if ( handle.exists() ){
		      reader = new BufferedReader(new FileReader(handle));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  handleData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (listdlls)
		try {
		   if ( listdlls.exists() ){
		      reader = new BufferedReader(new FileReader(listdlls));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  listdllsData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (nbtstat)
		try {
		   if ( nbtstat.exists() ){
		      reader = new BufferedReader(new FileReader(nbtstat));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  nbtstatData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (procinterrogate)
		try {
		   if ( procinterrogate.exists() ){
		      reader = new BufferedReader(new FileReader(procinterrogate));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  procinterrogateData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (ps)
		try {
		   if ( ps.exists() ){
		      reader = new BufferedReader(new FileReader(ps));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  psData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (psfile)
		try {
		   if ( psfile.exists() ){
		      reader = new BufferedReader(new FileReader(psfile));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  psfileData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (psinfo)
		try {
		   if ( psinfo.exists() ){
		      reader = new BufferedReader(new FileReader(psinfo));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  psinfoData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (pslist)
		try {
		   if ( pslist.exists() ){
		      reader = new BufferedReader(new FileReader(pslist));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  pslistData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (psloggedon)
		try {
		   if ( psloggedon.exists() ){
		      reader = new BufferedReader(new FileReader(psloggedon));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  psloggedonData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (psservice)
		try {
		   if ( psservice.exists() ){
		      reader = new BufferedReader(new FileReader(psservice));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  psserviceData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (pulist)
		try {
		   if ( pulist.exists() ){
		      reader = new BufferedReader(new FileReader(pulist));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  pulistData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (prefetch)
		try {
		   if ( prefetch.exists() ){
		      reader = new BufferedReader(new FileReader(prefetch));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  prefetchData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (sfind)
		try {
		   if ( sfind.exists() ){
		      reader = new BufferedReader(new FileReader(sfind));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  sfindData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (streams)
		try {
		   if ( streams.exists() ){
		      reader = new BufferedReader(new FileReader(streams));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  streamsData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (dumpelAppLog)
		try {
		   if ( dumpelAppLog.exists() ){
		      reader = new BufferedReader(new FileReader(dumpelAppLog));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  dumpelAppLogData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (dumpelSecLog)
		try {
		   if ( dumpelSecLog.exists() ){
		      reader = new BufferedReader(new FileReader(dumpelSecLog));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  dumpelSecLogData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (dumpelSysLog)
		try {
		   if ( dumpelSysLog.exists() ){
		      reader = new BufferedReader(new FileReader(dumpelSysLog));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  dumpelSysLogData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (promiscDetect)
		try {
		   if ( promiscDetect.exists() ){
		      reader = new BufferedReader(new FileReader(promiscDetect));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  promiscDetectData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (Tasklist)
		try {
		   if ( Tasklist.exists() ){
		      reader = new BufferedReader(new FileReader(Tasklist));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  TasklistData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (tcpvcon)
		try {
		   if ( tcpvcon.exists() ){
		      reader = new BufferedReader(new FileReader(tcpvcon));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  tcpvconData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (sl)
		try {
		   if ( sl.exists() ){
		      reader = new BufferedReader(new FileReader(sl));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  slData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		//test for output file existence (ls)
		try {
		   if ( ls.exists() ){
		      reader = new BufferedReader(new FileReader(ls));
		      while ( (nextLine = reader.readLine()) != null ){
		    	  lsData += nextLine;  
		      }
		   }
		} catch (FileNotFoundException fnfe) {
			; //take no action, just continue
		} catch (IOException ioe){
			; //take no action, just continue
		}
		
		numThreats = 0;
		int numRootkits = 0;
		
		//rootkit detection phase
		
		//apiHookCheckData
		
		
		//arpData
		
		
		//auditpolData
		
		
		//dirHiddenFilesData
		
		
		//fportData
		
		
		//hfindData
		
		
		//ipconfig_OUTData
		
		
		//mem_OUTData
		
		
		//netstat_an_outData
		
		
		//netstat_anp_outData
		
		
		//netstat_anr_outData
		
		
		//route_outData
		
		
		//handleData
		
		
		//listdllsData
		
		
		//nbtstatData
		
		
		//procinterrogateData
		
		
		//psData
		
		
		//psfileData
		
		
		//psinfoData
		
		
		//pslistData
		
		
		//psloggedonData
		
		
		//psserviceData
		
		
		//pulistData
		
		
		//prefetchData
		
		
		//sfindData
		
		
		//streamsData
		
		
		//dumpelAppLogData
		
		
		//dumpelSecLogData
		
		
		//dumpelSysLogData
		
		
		//promiscDetectData
		
		
		//TasklistData
		
		
		//tcpvconData
		
		
		//slData
		
		
		//lsData	
		
		
		displayMessage("Analysis completed.\n" + numThreats + " potential threat(s) found.\n" + numRootkits + " possible rootkit(s) found.");
	}
	
	//display message
	public void displayMessage(String message){
	   if ( message != null ){
	      statusBar.setText(message);
	      validate();
	   }
	}
	
	//	main method used to invoke the battle calculator
	public static void main(String[] args) {
       GUIFrame caveman = new GUIFrame();
       caveman.validate();
	}
}
